/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logd;

import com.ibm.hwmca.base.logd.GetDisplayerName;
import com.ibm.hwmca.base.logd.HexDisplayerBean;
import com.ibm.hwmca.base.logd.IssueCmd;
import com.ibm.hwmca.base.logd.LogDisplayer;
import com.ibm.hwmca.base.logd.LogErrorIdsLogD;
import com.ibm.hwmca.base.logd.TextExpanderTasklet;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.logd.DisplayerExpanderData;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.TaskActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;

public class DllExpanderTasklet
extends TextExpanderTasklet
implements LogErrorIdsLogD {
    private static final String TRACE_MASKT = "XLOGDEDT";
    private static final String TRACE_MASKD = "XLOGDEDD";
    private static final String TRACE_MASKF = "XLOGDEDF";
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogDisplayer");
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.logd.res.LogDisplayerRes";
    private static final String DLL_MAP_FILE = "LogClassDllMap.properties";
    private static final String EXPANDER_PANEL_NAME = "ExpanderDisplayerPanel";
    private static final String RECORD_OPTION = "recordOption";
    private static final String FILE_FLAGS = "flags";
    private HexDisplayerBean _hexDisplayerBean = new HexDisplayerBean();
    private static final String EXE_CMD = "iqyyxpdk";
    private Log _logData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace("XLOGDEDT", "-> DllExpanderTasklet.service()");
        tmpFileName = null;
        tmpFile = null;
        fos = null;
        logClassStr = null;
        logTypeStr = null;
        logBlockIdStr = null;
        if (taskletRequest.isInitialRequest()) {
            Trace.trace("XLOGDEDF", "DllExpanderTasklet - doing InitialRequest");
            displayerExpanderData = this.retrieveExpanderData(taskletRequest, taskletResponse);
            if (!taskletResponse.isResponseSet()) {
                hexData = displayerExpanderData.getHexData();
                Trace.trace("XLOGDEDF", "get data for the dll expander ");
                log = displayerExpanderData.getLogData();
                logBlock = displayerExpanderData.getLogBlock();
                logClass = log.getLogClass();
                logClassStr = HexString.toHex(logClass, true).toUpperCase();
                logType = log.getLogType();
                logTypeStr = HexString.toHex(logType, true).toUpperCase();
                block = logBlock.getBlockId();
                logBlockIdStr = HexString.toHex(block, true).toUpperCase();
                displayerName = null;
                entryPoint = null;
                name = GetDisplayerName.getDisplayerName("LogClassDllMap.properties", logClassStr, logTypeStr, logBlockIdStr, "dllExp: ");
                if (name == null || name.length() == 0) {
                    Trace.trace("XLOGDEDF", "dllExpName/EntryPoint returned is null");
                } else {
                    Trace.trace("XLOGDEDF", "dllExpName/EntryPoint=" + name);
                    len = name.length();
                    cont = true;
                    i = 0;
                    while (i < len && cont) {
                        if (Character.isWhitespace(name.charAt(i))) {
                            displayerName = name.substring(0, i);
                            ++i;
                            while (i < len && cont) {
                                if (!Character.isWhitespace(name.charAt(i))) {
                                    entryPoint = name.substring(i);
                                    cont = false;
                                }
                                ++i;
                            }
                        }
                        ++i;
                    }
                }
                if (displayerName == null || displayerName.length() == 0 || entryPoint == null || entryPoint.length() == 0) {
                    Trace.trace("XLOGDEDF", "Couldn't retrieve the dll or entry point, thus, use hex displayer");
                    super.hexService(taskletRequest, taskletResponse);
                } else {
                    Trace.trace("XLOGDEDF", "dllExpName=" + displayerName + " entryPoint=" + entryPoint);
                    try {
                        continueProcessing = true;
                        try {
                            directory = new File(BaseFileControl.getFilePath("tmp"));
                            tmpFile = File.createTempFile("LogExpander", ".trm", directory);
                            tmpFileName = tmpFile.getAbsolutePath();
                            Trace.trace("XLOGDEDF", "tmp dllDatafile Name =[" + tmpFileName + "]");
                            fos = new FileOutputStream(tmpFile);
                            fos.write(hexData);
                            fos.close();
                            fos = null;
                        }
                        catch (Exception e) {
                            Trace.trace("XLOGDEDF", "unable to create/writeData to tmp file, thus, use hex displayer");
                            continueProcessing = false;
                            super.hexService(taskletRequest, taskletResponse);
                        }
                        recordOption = 0;
                        fileFlag = 0;
                        if (!continueProcessing) ** GOTO lbl167
                        cmd = null;
                        try {
                            recordOption = this.getShortField(log, "recordOption");
                            fileFlag = this.getShortField(log, "flags");
                        }
                        catch (Exception ex) {
                            Trace.trace("XLOGDEDF", "Error retrieving private log data");
                            Trace.trace("XLOGDEDF", ex);
                            continueProcessing = false;
                            super.hexService(taskletRequest, taskletResponse);
                        }
                        if (!continueProcessing) ** GOTO lbl167
                        try {
                            logBlocks = log.getLogBlocks();
                            date = log.getTimestamp();
                            time = date.getTime();
                            Trace.trace("XLOGDEDF", "milliSec=" + time + " hexDataLen=" + hexData.length);
                            eventName = log.getEventName();
                            if (eventName == null || eventName.length() == 0) {
                                eventName = " ";
                            }
                            Trace.trace("XLOGDEDF", "befEventName=[" + eventName + "]");
                            eventNameLen = eventName.length();
                            eventNameBuf = new StringBuffer(eventNameLen);
                            i = 0;
                            while (i < eventNameLen) {
                                if (eventName.charAt(i) == ' ') {
                                    eventNameBuf.append('0');
                                } else {
                                    eventNameBuf.append('1');
                                }
                                ++i;
                            }
                            eventName = eventName.replace(' ', '.');
                            Trace.trace("XLOGDEDF", "aftEventName=[" + eventName + "]");
                            cmd = "iqyyxpdk " + displayerName + " " + entryPoint + " " + "!" + tmpFileName + " " + HexString.toHex(tmpFile.length()) + " " + HexString.toHex(logBlocks.length) + " " + HexString.toHex(recordOption) + " " + HexString.toHex(logClass, true) + "  " + HexString.toHex(logType, true) + " " + HexString.toHex(log.getUser()) + " " + HexString.toHex(time / 1000L) + " " + HexString.toHex(time % 1000L / 10L) + " " + HexString.toHex(fileFlag) + " " + HexString.toHex(block, true) + " " + eventName + " " + eventNameBuf;
                            Trace.trace("XLOGDEDF", "EXE cmd=" + cmd);
                            str = IssueCmd.exeString(cmd);
                            if (str.equals(null) || str.equals("")) {
                                Trace.trace("XLOGDEDF", "No data in the expander processed string.  Use hex displayer");
                                continueProcessing = false;
                                super.hexService(taskletRequest, taskletResponse);
                            }
                            Trace.trace("XLOGDEDF", "String len of expander data is" + str.length());
                            super.setUp(1, str);
                            super.service(taskletRequest, taskletResponse);
                        }
                        catch (IOException ioe) {
                            Trace.trace("XLOGDEDF", "unable to issue exe=iqyyxpdk use hex displayer");
                            super.hexService(taskletRequest, taskletResponse);
                            continueProcessing = false;
                        }
                    }
                    finally {
                        try {
                            if (fos != null) {
                                fos.close();
                            }
                        }
                        catch (IOException ioe) {
                            Trace.trace("XLOGDEDF", "Error closing dll expander's tmp file stream.");
                            Trace.trace("XLOGDEDF", ioe);
                        }
                        if (tmpFile != null) {
                            tmpFile.delete();
                        }
                    }
                }
            }
        } else if (taskletRequest.isDisposed() || taskletRequest.isCanceled()) {
            Trace.trace("XLOGDEDF", "before the log terminate");
            taskletResponse.terminate();
        } else {
            panelError = (String)taskletRequest.getData("panelError");
            if (panelError == null) {
                event = (TaskActionEvent)taskletRequest.getData("event");
                command = event.getActionCommand();
                panelName = (String)taskletRequest.getData("panelName");
                Trace.trace("XLOGDEDF", "Expander Displayer's command =" + command + " panelName=" + panelName);
                if (panelName.equals("expander")) {
                    if (command.equals("FileMenu.CancelItem")) {
                        taskletResponse.dispose();
                    } else if (command.equals("CANCEL")) {
                        taskletResponse.dispose();
                    } else {
                        Trace.trace("XLOGDEDF", "Unknown event received by the DllExpander panel. command=" + command);
                        taskletResponse.error(LogDisplayer._lUnknownEvent, null);
                    }
                } else if (panelName.equals("HexPanel")) {
                    Trace.trace("XLOGDEDF", "calling the HexExpander service()");
                    super.hexService(taskletRequest, taskletResponse);
                } else if (panelName.equals("TextPanel")) {
                    Trace.trace("XLOGDEDF", "calling the TextExpander service()");
                    super.service(taskletRequest, taskletResponse);
                } else if (panelName.equals("FileNamePanelWrite")) {
                    Trace.trace("XLOGDEDF", "calling the TextExpander service() going to the FileNameWrite panel processing");
                    super.service(taskletRequest, taskletResponse);
                }
            } else {
                Trace.trace("XLOGDEDF", "DllExpanderTasklet panelErr=" + panelError);
                taskletResponse.terminate();
            }
        }
lbl167:
        // 15 sources

        Trace.trace("XLOGDEDT", "<- DllExpanderTasklet.service()");
    }

    public DisplayerExpanderData retrieveExpanderData(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<->  DllExpanderTasklet.retrieveExpanderData()");
        return super.retrieveExpanderData(taskletRequest, taskletResponse);
    }

    private short getShortField(Log log, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        Trace.trace(TRACE_MASKF, "->  getField() for ", fieldName);
        Class<?> logClass = log.getClass();
        Field field = logClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        short data = field.getShort(log);
        Trace.trace(TRACE_MASKF, "<-  getField() " + fieldName + "=" + HexString.toHex(data));
        return data;
    }

    public void logException(Throwable e) {
        Trace.trace(TRACE_MASKT, "-> DllExpanderTasklet.logException()");
        Trace.trace(TRACE_MASKF, e);
        new FrameworkLog(_logInfo, 1369, e).log();
        Trace.trace(TRACE_MASKT, "<- DllExpanderTasklet.logException()");
    }
}

